<?php
/**
 * Project: MinervaKB.
 * Copyright: 2015-2017 @KonstruktStudio
 */

class MinervaKB_RelatedShortcode extends KST_Shortcode implements KST_Shortcode_Interface {

	protected $ID = 'related';
	protected $name = 'Related Articles';
	protected $description = 'Block with related content links';
	protected $icon = 'fa fa-sitemap';

	public function render($atts, $content = '') {
		$args = wp_parse_args($atts, $this->get_defaults());

        $title = isset($args["title"]) && $args["title"] ? $args["title"] : MKB_Options::option('related_content_label');
        $mode = isset($args['mode']) ? $args['mode'] : 'manual';
        $limit = isset($args['limit']) ? $args['limit'] : 5;
		$ids = explode(",", $args["ids"]);

        if ($mode === 'topic') {
            $ids = array();

            if (!is_singular(MKB_Options::option('article_cpt'))) {
                echo __('<p>Warning! Current topic mode works only for KB articles</p>', 'minerva-kb');

                return;
            }

            $term = MKB_TemplateHelper::get_article_main_topic(get_the_ID());

            if (!$term) {
                return;
            }

            $query_args = array(
                'post_type' => MKB_Options::option( 'article_cpt' ),
                'ignore_sticky_posts' => 1,
                'posts_per_page' => $limit,
                'post__not_in' => array(get_the_ID()),
                'tax_query' => array(
                    array(
                        'taxonomy' => MKB_Options::option('article_cpt_category'),
                        'field' => 'slug',
                        'terms' => $term->slug,
                    ),
                )
            );

            $topic_loop = new WP_Query( $query_args );

            if ($topic_loop->have_posts()):
                while ( $topic_loop->have_posts() ) : $topic_loop->the_post();
                    array_push($ids, get_the_ID());
                endwhile;
            endif;

            wp_reset_postdata();
        }

		if ($ids && is_array($ids) && !empty($ids)):
			?>
			<div class="mkb-related-content">
				<div class="mkb-related-content-title"><?php echo esc_html($title); ?></div>
				<ul class="mkb-related-content-list">
					<?php foreach($ids as $id):
						if ( empty($id) || !is_string( get_post_status( $id )) ) {
							continue;
						}
						?>
						<li><a href="<?php echo esc_url(get_permalink($id)); ?>"><?php echo esc_html(get_the_title($id)); ?></a></li>
					<?php endforeach; ?>
				</ul>
			</div>
		<?php
		endif;
	}

	/**
	 * Returns all shortcode options
	 * @return array
	 */
	public static function get_options() {
		return array(
            array(
                'id' => 'title',
                'type' => 'input',
                'label' => __( 'Title (optional)', 'minerva-kb' ),
                'default' => '',
                'description' => __( 'By default, the title from global settings is used', 'minerva-kb' ),
            ),
            array(
                'id' => 'mode',
                'type' => 'select',
                'label' => __( 'Related articles mode', 'minerva-kb' ),
                'options' => array(
                    'manual' => __( 'Manual', 'minerva-kb' ),
                    'topic' => __( 'Current topic', 'minerva-kb' ),
                ),
                'default' => 'manual',
                'description' => __( 'Choose articles manually or display articles from current topic', 'minerva-kb' ),
                'admin_label' => true
            ),
            array(
                'id' => 'limit',
                'type' => 'input',
                'label' => __( 'Limit articles from current topic', 'minerva-kb' ),
                'default' => 5,
                'description' => __( 'For Current topic mode. Use -1 to show all.', 'minerva-kb' ),
                'dependency' => array(
                    'target' => 'mode',
                    'type' => 'EQ',
                    'value' => 'topic'
                )
            ),
			array(
				'id' => 'ids',
				'type' => 'articles_list',
				'label' => __( 'Select related articles', 'minerva-kb' ),
				'default' => '',
				'admin_label' => true,
                'dependency' => array(
                    'target' => 'mode',
                    'type' => 'EQ',
                    'value' => 'manual'
                )
			),
		);
	}
}